# Shofy - Beauty & Cosmetics – Full Stack eCommerce Web Application + Admin Panel


![Shofy Image Banner](https://i.ibb.co/yBHL1wj/beauty-cosmetics.png)

Shofy Beauty & Cosmetics is a powerful and modern full stack eCommerce web application built using Next.js, Express.js, MongoDB with Mongoose, Redux Toolkit, RTK Query, Stripe payment method, Bootstrap 5, and Sass. It includes a feature-rich admin panel for easy management and control of your online store.

## Features Overview

- **Next.js:** Next.js is The React Framework for Production, providing a fast and scalable foundation for your eCommerce website.
- **Express.js:** Express.js is a minimal and flexible Node.js web application framework that offers a robust set of features for web and mobile applications.
- **MongoDB:** MongoDB is a developer-friendly data platform that provides the services and tools necessary to build distributed applications at scale.
- **Mongoose:** Mongoose provides a straightforward, schema-based solution to model your application data, offering built-in type casting, validation, and query building.
- **Stripe:** Stripe offers online payment solutions, allowing you to create a secure and reliable website with e-commerce functionality.
- **Nodemailer:** Nodemailer is a module for Node.js applications that facilitates easy email sending, keeping your users informed and engaged.
- **Authentication:** Shofy includes features for Google login, user registration, email verification, forgot password, reset password, and profile updates.
- **Redux Toolkit:** Manage state effortlessly with Redux Toolkit, providing a convenient and efficient way to handle state in your application.
- **RTK Query:** RTK Query is a powerful data fetching and caching tool, ensuring efficient data retrieval for a smoother user experience.
- **Typescript + Next.js App Directory:** Shofy leverages TypeScript in combination with Next.js, enhancing code reliability and maintainability.
- **Form Validation:** Ensure data accuracy and consistency with form validation capabilities.
- **Bootstrap 5 (latest Version) Framework:** Bootstrap is a popular HTML, CSS, and JS framework for responsive, mobile-first projects.
- **Responsive Layout Design:** Shofy is fully responsive across all devices, providing a seamless experience for your customers.
- **Touch Friendly:** The web application is designed for easy browsing on touch devices, making it accessible to a wide range of users.

## Full Features List

- **React JS:** Utilize the power of React.js to create dynamic and interactive user interfaces.
- **Next.js:** The React Framework for Production, optimizing your web application's performance.
- **Express.js:** Create a robust backend for your eCommerce website using Express.js.
- **MongoDB:** Store and retrieve data efficiently with the flexibility and scalability of MongoDB.
- **Mongoose:** Model your application data effortlessly with Mongoose's schema-based solution.
- **Stripe:** Integrate secure and reliable payment solutions into your online store.
- **Nodemailer:** Keep your users informed with easy email sending capabilities.
- **Authentication:** Enable secure user registration, login, and profile updates, including Google login option.
- **Redux Toolkit:** Efficiently manage state in your application with Redux Toolkit.
- **Dynamic Routes:** Create dynamic and user-friendly URLs for enhanced navigation.
- **Based on Bootstrap 5.x:** Utilize the latest version of Bootstrap for responsive and customizable design elements.
- **Free Premium Quality Support:** Enjoy premium support for a smooth development experience.
- **Logo Slider Integration:** Showcase your brand and products with a logo slider.
- **Sticky Header:** Improve user navigation with a sticky header that remains visible as users scroll.
- **Google Fonts:** Access a wide range of fonts from Google Fonts for creative typography.
- **100% Responsive:** Ensure a seamless experience on all devices with a fully responsive layout.
- **Nice and Clean Design:** Present your products with a clean and professional design.
- **Clean and Commented Code:** Maintainable and well-organized code for easy customization.
- **Customizable Components:** Tailor the components of each page to match your brand identity.
- **Integrated with FontAwesome:** Utilize FontAwesome icons to enhance the visual appeal of your website.
- **Multiple Home Pages:** Choose from a variety of home page designs to best suit your business.
- **Inner Pages:** Access a range of inner pages for various sections of your eCommerce website.
- **Image Background:** Customize page backgrounds with visually appealing images.
- **Flexible and Multi-Purpose:** Shofy is versatile and can be adapted to various eCommerce niches.
- **Valid CSS3:** Comply with modern CSS standards for a better user experience.
- **24/7 Awesome Support:** Get continuous support for any inquiries or issues you may encounter.
- **Detailed Documentation:** Access comprehensive documentation for easy development and setup.

## Powerful Additional Features

- **All E-commerce Features and Apps Included:** Shofy provides a comprehensive eCommerce solution with all the essential features and apps needed for a successful online store.
- **Variation Swatch:** Create clean and professional product pages with variation swatches that capture your customer's attention and allow easy selection of product variations.
- **Filter Variations, Pagination, Filters by Size & Color:** Improve user experience and boost conversion rates by reducing the time needed for customers to complete their orders through filtering options and pagination.
- **Video Gallery:** Offer customers a detailed view of products with an engaging video gallery that showcases products from different angles or in use.
- **Sale Countdown Timer:** Increase sales and engagement for special occasions or limited-time offers with sale countdown timers that create a sense of urgency for shoppers.
- **Product Quick View:** Enable customers to view product details without leaving their current page, providing a convenient and efficient shopping experience.
- **Quantity Select:** Provide users with two options for selecting product quantities: a dropdown select box or manual input for more flexibility.
- **Google and Email Password-based Authentication:** Secure user accounts with authentication methods, including Google login and email-based password authentication.
- **User Profile and Information Update:** Allow users to update their profile information, ensuring accurate and up-to-date data for future interactions.
- **Powerful Payment Gateway Integration using Stripe:** Securely process payments with Stripe integration, providing a smooth and reliable shopping experience for customers.

## Installation and Usage

To get started with Shofy, follow these steps:

1. Clone the repository:

   ```bash
   https://github.com/Hamed-Hasan/shofy-Beauty-and-Cosmetics-ecommerce-client.git
   ```

2. Install dependencies:

   ```bash
   npm install
   ```

3. Configure environment variables.

4. Build the project:

   ```bash
   npm run build
   ```

5. Start the server:

   ```bash
   npm run dev
   ```

6. Access the application at the specified URL.

## Client Side Live Link

[Shofy Client Side Live Link](https://shofy-beauty-cosmetics-ecommerce.vercel.app)

## Server Side Live Link

[Shofy Server Side Live Link](https://shofy-backend.vercel.app)

## Client Side Repo

[Shofy Client Side Repo](https://github.com/Hamed-Hasan/shofy-Beauty-and-Cosmetics-ecommerce-client.git)

## Server Side Repo

[Shofy Server Side Repo](https://github.com/Hamed-Hasan/shofy-Beauty-and-Cosmetics-ecommerce-backend.git)

## Sources and Credits

- Twitter Bootstrap
- Swiper Slider
- Google Fonts
- Free Font Awesome Icons by Fontawesome

## Thank You for Choosing Shofy!

We hope you find Shofy to be a powerful and effective solution for your eCommerce needs. Should you encounter

 any issues or have any questions, please feel free to reach out to our support team at swe.hamedhasan@gmail.com. Happy selling!















 